/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.state;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.object.PlayState;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public record AnimationTest<T extends GeoAnimatable>(T animatable, GeoRenderState renderState, AnimatableManager<T> manager, AnimationController<T> controller) {
    public boolean isMoving() {
        return this.renderState.getOrDefaultGeckolibData(DataTickets.IS_MOVING, false);
    }

    public void setAnimation(RawAnimation animation) {
        this.controller.setAnimation(animation);
    }

    public PlayState setAndContinue(RawAnimation animation) {
        this.controller.setAnimation(animation);
        return PlayState.CONTINUE;
    }

    public boolean isCurrentAnimation(RawAnimation animation) {
        return Objects.equals(this.controller.getCurrentRawAnimation(), animation);
    }

    public boolean isCurrentAnimationStage(String name) {
        return this.controller.getCurrentAnimationPoint() != null && this.controller.getCurrentAnimationPoint().animation().name().equals(name);
    }

    public void setControllerSpeed(float speed) {
        this.controller.setAnimationSpeed(speed);
    }

    public boolean hasData(DataTicket<?> dataTicket) {
        return this.renderState.hasGeckolibData(dataTicket);
    }

    public <D> @Nullable D getData(DataTicket<D> dataTicket) {
        return this.renderState.getGeckolibData(dataTicket);
    }

    @Contract(value="_,null->null;_,!null->!null")
    public <D> @Nullable D getDataOrDefault(DataTicket<D> dataTicket, @Nullable D defaultValue) {
        D data = this.getData(dataTicket);
        return data != null || this.renderState.hasGeckolibData(dataTicket) ? data : defaultValue;
    }
}

